#include <stdio.h>
#include <stdlib.h>

struct node {
	int value;
	struct node *next;
};

struct node *add(int v)
{
	struct node *n;

	/* allocate node storage */
	n = malloc( sizeof(struct node) );
	if( n==NULL )
		return(n);

	/* addign values */
	n->value = v;
	n->next = NULL;

	return(n);
}

int main()
{
	struct node *base = NULL;	/* initialize */
	int x,count;

	/* loop to add nodes and values */
	count = 0;
	while(1)
	{
		printf("Enter Node %d value, zero to end: ",count);
		scanf("%d",&x);
		/* end the loop on zero */
		if( x== 0 )
			break;

		/* base must be initially allocated */
		if( base==NULL )
		{
			base = malloc( sizeof(struct node) );
			if( base==NULL )
			{
				fprintf(stderr,"Initial allocation failed\n");
				exit(1);
			}
		}
		else
		{
			base = realloc(base,((count+1)*sizeof(struct node)));
			if( base==NULL )
			{
				fprintf(stderr,"Unable to reallocate\n");
				exit(1);
			}
		}
		(base+count)->value = x;
		(base+count)->next = NULL;
		count++;
	}

	/* output results */
	printf("%d items input\n",count);
	for( x=0; x<count; x++ )
		printf("Node %d: %d\n",
				x,
				(base+x)->value
			  );

	/* clean-up */
	free(base);		/* only need to free the one node */
	return 0;
}
