#include <stdio.h>
#include <stdlib.h>

/* must define the structure externally */
struct person {
	char name[16];
	int age;
};

/* the structure is complex, so it helps
   here to unwind it before making the
   comparison */
int compare(const void *a, const void *b)
{
	/* unique structure pointers */
	struct person *alpha;
	struct person *beta;
	int result;

	/* assign our structure pointers to the
	   void pointers */
	alpha = (struct person *)a;
	beta = (struct person *)b;
	/* calculate the result */
	result = alpha->age - beta->age;
	return( result );
}

int main()
{
	int size,x;
	struct person people[] = {
		{ "Adam", 32 },
		{ "Barbara", 26 },
		{ "Charlie", 51 },
		{ "Diane", 18 },
		{ "Edmond", 39 },
		{ "Fanny", 6 }
	};
	
	/* obtain array size */
	size = sizeof(people)/sizeof(people[0]);

	/* output original */
	puts("Original array:");
	for( x=0; x<size; x++ )
		printf("%s is %d\n",
				people[x].name,
				people[x].age
			  );

	/* quick sort */
	qsort( people, size, sizeof(struct person), compare );

	/* output sorted */
	puts("Sorted array:");
	for( x=0; x<size; x++ )
		printf("%s is %d\n",
				people[x].name,
				people[x].age
			  );

	return 0;
}
