#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int main()
{
	const char *filename = "pres0.dat";
	struct person {
		char name[32];
		int age;
	} *president;
	FILE *fp;

	/* allocate storage */
	president = malloc( sizeof(president) );
	if( president==NULL )
	{
		fprintf(stderr,"Allocation failure\n");
		exit(1);
	}
	puts("Memory allocated");

	/* fill storage */
	strcpy(president->name,"George Washington");
	president->age = 57;
	puts("Memory filled");

	/* open the file */
	fp = fopen(filename,"w");
	if( fp==NULL )
	{
		fprintf(stderr,"Unable to create %s\n",
				filename
			   );
		exit(1);
	}

	/* save the structure */
	fwrite(president,sizeof(president),1,fp);
	puts("Data saved");

	/* clean-up */
	fclose(fp);
	free(president);
	return 0;
}
