#include <stdio.h>
#include <stdlib.h>

int main()
{
	const char *filename = "pres0.dat";
	struct person {
		char name[32];
		int age;
	} *president;
	FILE *fp;

	/* allocate storage */
	president = malloc( sizeof(struct person) );
	if( president==NULL )
	{
		fprintf(stderr,"Allocation failure\n");
		exit(1);
	}
	puts("Memory allocated");

	/* open the file */
	fp = fopen(filename,"r");
	if( fp==NULL )
	{
		fprintf(stderr,"Unable to read file %s\n",
				filename
			   );
		exit(1);
	}

	/* fill the buffer */
	fread(president,sizeof(struct person),1,fp);
	puts("Data read");

	/* output results */
	printf("%s is %d years old\n",
			president->name,
			president->age
		  );

	/* clean-up */
	fclose(fp);
	free(president);
	return 0;
}
